# common-middleware [![NPM version](https://img.shields.io/npm/v/common-middleware.svg?style=flat)](https://www.npmjs.com/package/common-middleware) [![NPM downloads](https://img.shields.io/npm/dm/common-middleware.svg?style=flat)](https://npmjs.org/package/common-middleware) [![Build Status](https://img.shields.io/travis/jonschlinkert/common-middleware.svg?style=flat)](https://travis-ci.org/jonschlinkert/common-middleware)

Common middleware for applications built with base-methods (like assemble, verb, generate, and update)

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save common-middleware
```

## Usage

```js
var middleware = require('common-middleware');
var assemble = require('assemble-core');

// create your app
var app = assemble();

// register the middleware
app.use(middleware());
```

## Middleware

The following middleware are included.

### [front matter](index.js#L41)

Parses front-matter on files that match `options.extRegex` and
adds the resulting data object to `file.data`. This object is
passed as context to the template engine at render time.

### [unescape templates](index.js#L59)

Registers a `.preWrite` middleware for unescaping escaped delimiters.

### [escape templates](index.js#L124)

Uses C-style macros to escape templates with `{%%= foo %}` or
`<%= foo %>` syntax, so they will not be evaluated by a template
engine when `.render` is called.

### [JSON on-load](index.js#L174)

Adds a `json` property to the `file` object when the file extension
matches `options.jsonRegex`. This allows JSON files to be updated
by other middleware or pipeline plugins without having to parse and
stringify with each modification.

### [JSON pre-write](index.js#L202)

If `file.contents` has not already been updated directly, the `file.contents` property
is updated with stringified JSON before writing the file back to the file
system.

## Options

### options.jsonRegex

Customize the regex used for matching JSON files.

**Example**

```js
app.use(middleware({jsonRegex: /\.json$/}));
```

### options.extRegex

Customize the regex used for matching template file extensions.

**Example**

```js
app.use(middleware({jsonRegex: /\.(hbs|tmpl)$/}));
```

### options.escapeRegex

Customize the regex used for matching the extensions of files with templates to escape.

**Example**

```js
app.use(middleware({jsonRegex: /\.(tmpl|hbs)$/}));
```

## About

### Related projects

* [assemble-core](https://www.npmjs.com/package/assemble-core): The core assemble application with no presets or defaults. All configuration is left to the… [more](https://github.com/assemble/assemble-core) | [homepage](https://github.com/assemble/assemble-core "The core assemble application with no presets or defaults. All configuration is left to the implementor.")
* [base](https://www.npmjs.com/package/base): base is the foundation for creating modular, unit testable and highly pluggable node.js applications, starting… [more](https://github.com/node-base/base) | [homepage](https://github.com/node-base/base "base is the foundation for creating modular, unit testable and highly pluggable node.js applications, starting with a handful of common methods, like `set`, `get`, `del` and `use`.")
* [generate](https://www.npmjs.com/package/generate): Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the… [more](https://github.com/generate/generate) | [homepage](https://github.com/generate/generate "Command line tool and developer framework for scaffolding out new GitHub projects. Generate offers the robustness and configurability of Yeoman, the expressiveness and simplicity of Slush, and more powerful flow control and composability than either.")
* [update](https://www.npmjs.com/package/update): Be scalable! Update is a new, open source developer framework and CLI for automating updates… [more](https://github.com/update/update) | [homepage](https://github.com/update/update "Be scalable! Update is a new, open source developer framework and CLI for automating updates of any kind in code projects.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/common-middleware/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.1.28, on August 02, 2016._