#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const minimist = require("minimist");
const fs = require("fs");
const Path = require("path");
const index_1 = require("../index");
const args = minimist(process.argv.slice(2));
if (args._.length !== 1 || args.h || args.help) {
    console.error(`compile-config compiles a Components.js config file to a JavaScript module

Usage:
  compile-config http://example.org/myInstance -c config.jsonld
  cat config.jsonld | compile-config http://example.org/myInstance

Options:
  -c      Path to a Components.js config file, if not provided, the config must be provided via stdin
  -p      The main module path, if not provided, this defaults to the working directory
  -g      If global modules should be included as well next to local modules.
  -e      The instance by config URI that will be exported, by default this is the provided instance URI.
  --help  print this help message
      `);
    process.exit(1);
}
const configResourceUri = args._[0];
let configStreamRaw;
let configPath;
if (args.c) {
    configStreamRaw = fs.createReadStream(args.c, { encoding: 'utf8' });
    configPath = args.c;
}
else {
    configStreamRaw = process.stdin;
    configPath = '.';
}
let mainModulePath;
if (args.p) {
    mainModulePath = Path.resolve(process.cwd(), args.p);
}
else {
    mainModulePath = process.cwd();
}
let exportVariableName = null;
if (args.e) {
    exportVariableName = args.e;
}
const scanGlobal = !!args.g;
index_1.compileConfig({ mainModulePath, scanGlobal }, configPath, configStreamRaw, configResourceUri, exportVariableName).then(console.log).catch(console.error);
//# sourceMappingURL=compile-config.js.map