/// <reference types="node" />
import { LoaderProperties } from "./Loader";
import { Stream } from "stream";
/**
 * Compile a configuration stream to a JavaScript source file.
 * @param {LoaderProperties} properties Properties for the loader.
 * @param {string} configPath Path of the config file.
 * @param {"stream".internal.Stream} configStreamRaw Stream of the config file contents.
 * @param {string} configResourceUri URI of the config element to compile.
 * @param {string} exportVariableName An optional variable name to export instead of the default runner.
 * @return {Promise<string>} A string resolving to the JavaScript contents.
 */
export declare function compileConfig(properties: LoaderProperties, configPath: string, configStreamRaw: Stream, configResourceUri: string, exportVariableName?: string): Promise<string>;
