import { IComponentFactory, ICreationSettings } from "./IComponentFactory";
import { Resource } from "../rdf/Resource";
import { Loader } from "../Loader";
/**
 * Factory for component definitions of any type.
 */
export declare class ComponentFactory implements IComponentFactory {
    _moduleDefinition: any;
    _componentDefinition: any;
    _config: any;
    _overrideRequireNames: {
        [id: string]: string;
    };
    _componentRunner: Loader;
    constructor(moduleDefinition: Resource, componentDefinition: Resource, config: Resource, overrideRequireNames?: {
        [id: string]: string;
    }, componentRunner?: Loader);
    _getComponentFactory(): IComponentFactory;
    makeArguments(settings?: ICreationSettings): Promise<any[]>;
    create(settings?: ICreationSettings): Promise<any>;
}
