"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Util = require("../Util");
/**
 * Factory for component definitions of any type.
 */
class ComponentFactory {
    constructor(moduleDefinition, componentDefinition, config, overrideRequireNames, componentRunner) {
        this._moduleDefinition = moduleDefinition;
        this._componentDefinition = componentDefinition;
        this._config = config;
        this._overrideRequireNames = overrideRequireNames;
        this._componentRunner = componentRunner;
    }
    _getComponentFactory() {
        if (!this._config.requireName && !this._config.requireElement) {
            let constructable = !this._componentDefinition.types
                || !this._componentDefinition.hasType(Util.PREFIXES['oo'] + 'ComponentInstance');
            if (!this._componentDefinition.constructorArguments) {
                return new (require('./UnmappedNamedComponentFactory').UnmappedNamedComponentFactory)(this._moduleDefinition, this._componentDefinition, this._config, constructable, this._overrideRequireNames, this._componentRunner);
            }
            else {
                return new (require('./MappedNamedComponentFactory').MappedNamedComponentFactory)(this._moduleDefinition, this._componentDefinition, this._config, constructable, this._overrideRequireNames, this._componentRunner);
            }
        }
        else {
            return new (require('./UnnamedComponentFactory').UnnamedComponentFactory)(this._config, !this._config.types || !this._config.hasType(Util.PREFIXES['oo'] + 'ComponentInstance'), this._overrideRequireNames, this._componentRunner);
        }
    }
    makeArguments(settings) {
        return this._getComponentFactory().makeArguments(settings);
    }
    create(settings) {
        return this._getComponentFactory().create(settings);
    }
}
exports.ComponentFactory = ComponentFactory;
//# sourceMappingURL=ComponentFactory.js.map