import { UnnamedComponentFactory } from "./UnnamedComponentFactory";
import { Resource } from "../rdf/Resource";
import { Loader } from "../Loader";
/**
 * Factory for component definitions with semantic arguments and with constructor mappings.
 */
export declare class MappedNamedComponentFactory extends UnnamedComponentFactory {
    constructor(moduleDefinition: Resource, componentDefinition: Resource, config: any, constructable: boolean, overrideRequireNames?: {
        [id: string]: string;
    }, componentRunner?: Loader);
    static mapValue(resourceScope: Resource, v: any, params: any, rawValue?: boolean): any;
    /**
     * Map a resource object.
     * Only the values of object-resources will be mapped to its parameter value.
     * For example, the resource { k: Resource.newString('param0'), v: new Resource('http://example.org/param0') }
     * with params { 'http://example.org/param0': Resource.newString('abc') }
     * will be mapped to { k: Resource.newString('param0'), v: Resource.newString('abc') }.
     * @param resourceScope The resource scope to map in.
     * @param resource The resource to map.
     * @param params The parameters object.
     * @returns {any} The mapped resource.
     */
    static map(resourceScope: Resource, resource: any, params: any): any;
    /**
     * Create an unnamed component definition resource constructor.
     * The component definition's parameters will first be mapped, and then delegated to the component constructor.
     * @param moduleDefinition The module definition with parameter definitions.
     * @param componentDefinition The component definition with parameter instances.
     * @returns {(params:any)=>Resource} A function that takes a parameter object for mapping parameter names to values
     *                                   like { 'http://example.org/param0': Resource.newString('abc') }
     *                                   and returns an unnamed component definition resource.
     */
    static makeUnnamedDefinitionConstructor(moduleDefinition: any, componentDefinition: any): ((params: any) => Resource);
}
