import { UnnamedComponentFactory } from "./UnnamedComponentFactory";
import { Resource } from "../rdf/Resource";
import { Loader } from "../Loader";
/**
 * Factory for component definitions with semantic arguments and without constructor mappings.
 */
export declare class UnmappedNamedComponentFactory extends UnnamedComponentFactory {
    constructor(moduleDefinition: Resource, componentDefinition: Resource, config: any, constructable: boolean, overrideRequireNames?: {
        [id: string]: string;
    }, componentRunner?: Loader);
    /**
     * Create an unnamed component definition resource constructor.
     * The component definition's parameters will be delegated to the component constructor.
     * @param moduleDefinition The module definition with parameter definitions.
     * @param componentDefinition The component definition with parameter instances.
     * @returns {(params:any)=>Resource} A function that takes a parameter object for mapping parameter names to values
     *                                   like { 'http://example.org/param0': Resource.newString('abc') }
     *                                   and returns an unnamed component definition resource.
     */
    static makeUnnamedDefinitionConstructor(moduleDefinition: any, componentDefinition: any): ((params: any) => Resource);
}
