import { Resource } from "../rdf/Resource";
import { IComponentFactory, ICreationSettings } from "./IComponentFactory";
import { Loader } from "../Loader";
/**
 * Factory for component definitions with explicit arguments.
 */
export declare class UnnamedComponentFactory implements IComponentFactory {
    _componentDefinition: any;
    _constructable: boolean;
    _overrideRequireNames: {
        [id: string]: string;
    };
    _componentRunner: Loader;
    constructor(componentDefinition: Resource, constructable: boolean, overrideRequireNames?: {
        [id: string]: string;
    }, componentRunner?: Loader);
    _validateParam(resource: any, field: string, type: string, optional?: boolean): void;
    static getArgumentValue(value: any, componentRunner: Loader, settings?: ICreationSettings): Promise<any>;
    /**
     * @param settings The settings for creating the instance.
     * @returns New instantiations of the provided arguments.
     */
    makeArguments(settings?: ICreationSettings): Promise<any[]>;
    /**
     * Require a package if the module that was invoked has the given module name.
     * This is done by looking for the nearest package.json.
     * @param requireName The module name that should be required.
     * @returns {any} The require() result
     * @private
     */
    _requireCurrentRunningModuleIfCurrent(requireName: string): any;
    /**
     * @return {string} The index module path of the current running module.
     * @private
     */
    _getCurrentRunningModuleMain(): string;
    /**
     * @param settings The settings for creating the instance.
     * @returns A new instance of the component.
     */
    create(settings?: ICreationSettings): Promise<any>;
}
