"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
let jsonld = require("jsonld");
/**
 * A JsonLdStreamer converts an object to a triple stream.
 */
class JsonLdStreamer extends stream_1.Readable {
    constructor(data) {
        super({ objectMode: true });
        this._data = data;
        this._pushAll();
    }
    _pushAll() {
        jsonld.toRDF(this._data, (error, triples) => {
            if (error) {
                this.emit('error', error.details.cause.message);
            }
            else {
                for (var graphName in triples) {
                    triples[graphName].forEach((triple) => {
                        this.push({
                            subject: triple.subject.value,
                            predicate: triple.predicate.value,
                            object: this._convertEntity(triple.object)
                        });
                    });
                }
                this.push(null);
            }
        });
    }
    // Converts a jsonld.js entity to the N3.js in-memory representation
    _convertEntity(entity) {
        // Return IRIs and blank nodes as-is
        if (entity.type !== 'literal')
            return entity.value;
        else {
            // Add a language tag to the literal if present
            if ('language' in entity)
                return '"' + entity.value + '"@' + entity.language;
            // Add a datatype to the literal if present
            if (entity.datatype !== 'http://www.w3.org/2001/XMLSchema#string')
                return '"' + entity.value + '"^^' + entity.datatype;
            // Otherwise, return the regular literal
            return '"' + entity.value + '"';
        }
    }
}
exports.JsonLdStreamer = JsonLdStreamer;
//# sourceMappingURL=JsonLdStreamer.js.map