/// <reference types="node" />
import { Writable } from "stream";
import N3 = require('n3');
import { Resource } from "./Resource";
import Triple = N3.Triple;
/**
 * An RdfClassLoader is a writable stream that accepts triple streams and loads resources in-memory.
 * Class and property URI's can be bound to names.
 */
export declare class RdfClassLoader extends Writable {
    _options: {
        [id: string]: any;
    };
    _classes: {
        [id: string]: any;
    };
    _properties: {
        [id: string]: string;
    };
    _uniqueProperties: {
        [id: string]: boolean;
    };
    _captureAllProperties: boolean;
    _captureAllClasses: boolean;
    /**
     * Mapping from resource URI to resource instance.
     */
    resources: {
        [id: string]: Resource;
    };
    /**
     * Mapping from resource type name to an array of resource instances.
     */
    typedResources: {
        [id: string]: Resource[];
    };
    constructor(options?: any);
    /**
     * Bind the given class name to the given URI.
     * @param className The class name.
     * @param uri The class URI.
     */
    bindClass(className: string, uri: string): void;
    /**
     * Bind the given property field name to the given URI.
     * @param fieldName The field name.
     * @param uri The predicate URI.
     * @param unique If the property should be unique.
     */
    bindProperty(fieldName: string, uri: string, unique?: boolean): void;
    /**
     * Indicate that the given property is unique for a resource.
     * @param fieldName The field name of the property.
     */
    setUniqueProperty(fieldName: string): void;
    _getOrMakeResource(value: string): Resource;
    _pushPredicate(fieldName: string, triple: Triple): void;
    _write(triple: Triple, encoding: any, done: any): void;
}
