/// <reference types="node" />
import { PassThrough } from "stream";
/**
 * A RdfStreamIncluder takes a triple stream and detects owl:includes to automatically include other files.
 */
export declare class RdfStreamIncluder extends PassThrough {
    static RELATIVE_PATH_MATCHER: RegExp;
    _runningImporters: number;
    _constants: any;
    _fromPath: string;
    _followImports: boolean;
    _absolutizeRelativePaths: boolean;
    _contexts?: {
        [id: string]: string;
    };
    _importPaths?: {
        [id: string]: string;
    };
    constructor(constants: any, fromPath: string, followImports: boolean, absolutizeRelativePaths: boolean, contexts?: {
        [id: string]: string;
    }, importPaths?: {
        [id: string]: string;
    });
    push(data: any, encoding?: string): boolean;
    _absolutize(uri: string): string;
}
