"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
const N3 = require("n3");
const JsonLdStreamParser_1 = require("./JsonLdStreamParser");
const NodeUtil = require("util");
/**
 * A RdfStreamParser takes a text stream (N3 or JSON-LD) as input and parses it to a triple stream.
 */
class RdfStreamParser extends stream_1.PassThrough {
    constructor(contexts) {
        super({ decodeStrings: true });
        this._readableState.objectMode = true;
        this._n3Parser = new N3.StreamParser({ blankNodePrefix: 'n3b' });
        this._jsonParser = new JsonLdStreamParser_1.JsonLdStreamParser(contexts);
    }
    pipeFrom(target) {
        target.on('error', (e) => this.emit('error', e));
        var stream1 = target.pipe(new stream_1.PassThrough());
        var stream2 = target.pipe(new stream_1.PassThrough());
        stream1.pipe(this._n3Parser)
            .on('error', errorHandler)
            .on('data', (data) => this.push(data))
            .on('end', () => this.push(null), this.emit('end'));
        stream2.pipe(this._jsonParser)
            .on('error', (e) => errorHandler(e))
            .on('data', (data) => this.push(data))
            .on('end', () => this.push(null), this.emit('end'));
        let errors = [];
        let self = this;
        function errorHandler(e) {
            errors.push(e);
            if (errors.length === 2) {
                self.emit('error', new Error('No valid parser was found, both N3 and JSON-LD failed:\n' + NodeUtil.inspect(errors)));
            }
        }
        return this;
    }
}
exports.RdfStreamParser = RdfStreamParser;
//# sourceMappingURL=RdfStreamParser.js.map