"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const N3 = require("n3");
const Util = require("../Util");
const NodeUtil = require("util");
/**
 * A resource class.
 * Fields can be added at runtime, which will always be arrays.
 */
class Resource {
    constructor(value, fields) {
        this.value = N3.Util.isLiteral(value) ? N3.Util.getLiteralValue(value) : value;
        this.termType = N3.Util.isLiteral(value) ? 'Literal' : (N3.Util.isBlank(value) ? 'BlankNode' : 'NamedNode');
        if (fields) {
            let keys = Object.keys(fields);
            for (let i = 0; i < keys.length; i++) {
                this[keys[i]] = fields[keys[i]];
            }
        }
    }
    static newString(value) {
        return Resource.newTyped(value, 'string');
    }
    static newBoolean(value) {
        return Resource.newTyped(value, 'boolean');
    }
    static newTyped(value, type) {
        return new Resource('"' + value + '"^^' + Util.PREFIXES['xsd'] + 'type');
    }
    hasType(typeUri) {
        let resource = this;
        if (typeUri === this.value) {
            return true;
        }
        if (resource.types || resource.classes) {
            return (resource.types || []).concat(resource.classes || [])
                .reduce((acc, type) => acc || type.hasType(typeUri), false);
        }
        return false;
    }
    toString() {
        return NodeUtil.inspect(this);
    }
}
exports.Resource = Resource;
//# sourceMappingURL=Resource.js.map