"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bus_http_1 = require("@comunica/bus-http");
require("isomorphic-fetch");
const parseLink = require("parse-link-header");
/**
 * A comunica Memento Http Actor.
 */
class ActorHttpMemento extends bus_http_1.ActorHttp {
    constructor(args) {
        super(args);
    }
    async test(action) {
        if (!(action.context && action.context.has(exports.KEY_CONTEXT_DATETIME) &&
            action.context.get(exports.KEY_CONTEXT_DATETIME) instanceof Date)) {
            throw new Error('This actor only handles request with a set valid datetime.');
        }
        if (action.init && new Headers(action.init.headers || {}).has('accept-datetime')) {
            throw new Error('The request already has a set datetime.');
        }
        return true;
    }
    async run(action) {
        // Duplicate the ActionHttp to append a datetime header to the request.
        const init = action.init ? Object.assign({}, action.init) : {};
        const headers = init.headers = new Headers(init.headers || {});
        if (action.context && action.context.has(exports.KEY_CONTEXT_DATETIME)) {
            headers.append('accept-datetime', action.context.get(exports.KEY_CONTEXT_DATETIME).toUTCString());
        }
        const httpAction = { context: action.context, input: action.input, init };
        // Execute the request and follow the timegate in the response (if any).
        const result = await this.mediatorHttp.mediate(httpAction);
        // Did we ask for a time-negotiated response, but haven't received one?
        if (headers.has('accept-datetime') && result.headers && !result.headers.has('memento-datetime')) {
            // The links might have a timegate that can help us
            const links = result.headers.has('link') && parseLink(result.headers.get('link'));
            if (links && links.timegate) {
                result.body.cancel();
                // Respond with a time-negotiated response from the timegate instead
                const followLink = { context: action.context, input: links.timegate.url, init };
                return this.mediatorHttp.mediate(followLink);
            }
        }
        return result;
    }
}
exports.ActorHttpMemento = ActorHttpMemento;
/**
 * @type {string} Context entry for the desired datetime.
 */
exports.KEY_CONTEXT_DATETIME = '@comunica/actor-http-memento:datetime';
//# sourceMappingURL=ActorHttpMemento.js.map