const newEngine = require('..').newEngine;
const N3Store = require('n3').Store;
const DataFactory = require('n3').DataFactory;

// This can be any RDFJS source
// In this example, we wrap an N3Store
const store = new N3Store();
store.addQuad(DataFactory.quad(
  DataFactory.namedNode('a'), DataFactory.namedNode('b'), DataFactory.namedNode('http://dbpedia.org/resource/Belgium')));
store.addQuad(DataFactory.quad(
  DataFactory.namedNode('a'), DataFactory.namedNode('b'), DataFactory.namedNode('http://dbpedia.org/resource/Ghent')));
const source = {
  match: function(s, p, o, g) {
    return require('streamify-array')(store.getQuads(s, p, o, g));
  }
};

// Create our engine, and query it.
// If you intend to query multiple times, be sure to cache your engine for optimal performance.
const myEngine = newEngine();
myEngine.query('SELECT * { ?s ?p <http://dbpedia.org/resource/Belgium>. ?s ?p ?o } LIMIT 100',
  { sources: [ { type: 'rdfjsSource', value: source } ] })
  .then(function (result) {
    result.bindingsStream.on('data', function (data) {
      // Each data object contains a mapping from variables to RDFJS terms.
      console.log(data.get('?s'));
      console.log(data.get('?p'));
      console.log(data.get('?o'));
    });
  });