"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bus_rdf_join_1 = require("@comunica/bus-rdf-join");
const asyncjoin_1 = require("asyncjoin");
/**
 * A comunica NestedLoop RDF Join Actor.
 */
class ActorRdfJoinNestedLoop extends bus_rdf_join_1.ActorRdfJoin {
    constructor(args) {
        super(args, 2);
    }
    async getOutput(action) {
        const join = new asyncjoin_1.NestedLoopJoin(action.entries[0].bindingsStream, action.entries[1].bindingsStream, bus_rdf_join_1.ActorRdfJoin.join);
        return { type: 'bindings', bindingsStream: join, variables: bus_rdf_join_1.ActorRdfJoin.joinVariables(action) };
    }
    async getIterations(action) {
        return (await action.entries[0].metadata()).totalItems * (await action.entries[1].metadata()).totalItems;
    }
}
exports.ActorRdfJoinNestedLoop = ActorRdfJoinNestedLoop;
//# sourceMappingURL=ActorRdfJoinNestedLoop.js.map