"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bus_rdf_parse_1 = require("@comunica/bus-rdf-parse");
const jsonld_streaming_parser_1 = require("jsonld-streaming-parser");
/**
 * A JSON-LD RDF Parse actor that listens on the 'rdf-parse' bus.
 *
 * It is able to parse JSON-LD-based RDF serializations and announce the presence of them by media type.
 */
class ActorRdfParseJsonLd extends bus_rdf_parse_1.ActorRdfParseFixedMediaTypes {
    constructor(args) {
        super(args);
    }
    async runHandle(action, mediaType, context) {
        const quads = new jsonld_streaming_parser_1.JsonLdParser({ baseIRI: action.baseIRI, allowOutOfOrderContext: true })
            .import(action.input);
        return { quads };
    }
}
exports.ActorRdfParseJsonLd = ActorRdfParseJsonLd;
//# sourceMappingURL=ActorRdfParseJsonLd.js.map