"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bus_rdf_parse_1 = require("@comunica/bus-rdf-parse");
const n3_1 = require("n3");
/**
 * An N3 RDF Parse actor that listens on the 'rdf-parse' bus.
 *
 * It is able to parse N3-based RDF serializations and announce the presence of them by media type.
 */
class ActorRdfParseN3 extends bus_rdf_parse_1.ActorRdfParseFixedMediaTypes {
    constructor(args) {
        super(args);
    }
    async runHandle(action, mediaType, context) {
        action.input.on('error', (e) => quads.emit('error', e));
        const quads = action.input.pipe(new n3_1.StreamParser({ baseIRI: action.baseIRI }));
        return {
            quads,
            triples: mediaType === 'text/turtle'
                || mediaType === 'application/n-triples'
                || mediaType === 'text/n3',
        };
    }
}
exports.ActorRdfParseN3 = ActorRdfParseN3;
//# sourceMappingURL=ActorRdfParseN3.js.map