"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bus_rdf_serialize_1 = require("@comunica/bus-rdf-serialize");
const n3_1 = require("n3");
const stream_1 = require("stream");
/**
 * A comunica N3 RDF Serialize Actor.
 */
class ActorRdfSerializeN3 extends bus_rdf_serialize_1.ActorRdfSerializeFixedMediaTypes {
    constructor(args) {
        super(args);
    }
    async runHandle(action, mediaType, context) {
        const n3Triples = new stream_1.Readable({ objectMode: true });
        n3Triples._read = () => {
            return;
        };
        action.quads.on('error', (e) => data.emit('error', e));
        action.quads.on('data', (quad) => n3Triples.push(quad));
        action.quads.on('end', () => n3Triples.emit('end'));
        const data = n3Triples.pipe(new n3_1.StreamWriter({ format: mediaType }));
        return { data,
            triples: mediaType === 'text/turtle'
                || mediaType === 'application/n-triples'
                || mediaType === 'text/n3' };
    }
}
exports.ActorRdfSerializeN3 = ActorRdfSerializeN3;
//# sourceMappingURL=ActorRdfSerializeN3.js.map