import { ActionContext, IActorArgs, IActorTest } from "@comunica/core";
import { Algebra } from "sparqlalgebrajs";
import { ActorQueryOperation, IActionQueryOperation, IActorQueryOperationOutput } from "./ActorQueryOperation";
/**
 * A base implementation for query operation actors for a specific operation type.
 */
export declare abstract class ActorQueryOperationTyped<O extends Algebra.Operation> extends ActorQueryOperation {
    readonly operationName: string;
    constructor(args: IActorArgs<IActionQueryOperation, IActorTest, IActorQueryOperationOutput>, operationName: string);
    test(action: IActionQueryOperation): Promise<IActorTest>;
    run(action: IActionQueryOperation): Promise<IActorQueryOperationOutput>;
    protected abstract testOperation(operation: O, context: ActionContext): Promise<IActorTest>;
    protected abstract runOperation(operation: O, context: ActionContext): Promise<IActorQueryOperationOutput>;
}
