"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ActorQueryOperation_1 = require("./ActorQueryOperation");
/**
 * A base implementation for query operation actors for a specific operation type.
 */
class ActorQueryOperationTyped extends ActorQueryOperation_1.ActorQueryOperation {
    constructor(args, operationName) {
        super(args);
        this.operationName = operationName;
        if (!this.operationName) {
            throw new Error('A valid "operationName" argument must be provided.');
        }
    }
    async test(action) {
        if (!action.operation) {
            throw new Error('Missing field \'operation\' in the query operation action: ' + require('util').inspect(action));
        }
        if (action.operation.type !== this.operationName) {
            throw new Error('Actor ' + this.name + ' only supports ' + this.operationName + ' operations, but got '
                + action.operation.type);
        }
        const operation = action.operation;
        return this.testOperation(operation, action.context);
    }
    async run(action) {
        const operation = action.operation;
        const output = await this.runOperation(operation, action.context);
        if (output.metadata) {
            output.metadata =
                ActorQueryOperation_1.ActorQueryOperation.cachifyMetadata(output.metadata);
        }
        return output;
    }
}
exports.ActorQueryOperationTyped = ActorQueryOperationTyped;
//# sourceMappingURL=ActorQueryOperationTyped.js.map