"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const immutable_1 = require("immutable");
/**
 * A convenience constructor for bindings based on a given hash.
 * @param {{[p: string]: RDF.Term}} hash A hash that maps variable names to terms.
 * @return {Bindings} The immutable bindings from the hash.
 * @constructor
 */
function Bindings(hash) {
    return immutable_1.Map(hash);
}
exports.Bindings = Bindings;
/**
 * Check if the given object is a bindings object.
 * @param maybeBindings Any object.
 * @return {boolean} If the object is a bindings object.
 */
function isBindings(maybeBindings) {
    return immutable_1.Map.isMap(maybeBindings);
}
exports.isBindings = isBindings;
/**
 * Convert the given object to a bindings object if it is not a bindings object yet.
 * If it already is a bindings object, return the object as-is.
 * @param maybeBindings Any object.
 * @return {Bindings} A bindings object.
 */
function ensureBindings(maybeBindings) {
    return isBindings(maybeBindings) ? maybeBindings : Bindings(maybeBindings);
}
exports.ensureBindings = ensureBindings;
//# sourceMappingURL=Bindings.js.map