import { ActionContextKey } from '@comunica/core';
import type { IPhysicalQueryPlanLogger, QueryExplainMode, IProxyHandler, ICliArgsHandler, DataSources, IDataSource, IDataDestination, MetadataBindings } from '@comunica/types';
import type * as RDF from '@rdfjs/types';
import type { IDocumentLoader } from 'jsonld-context-parser';
import type { Algebra } from 'sparqlalgebrajs';
/**
 * When adding entries to this file, also add a shortcut for them in the contextKeyShortcuts TSDoc comment in
 * ActorIniQueryBase in @comunica/actor-init-query if it makes sense to use this entry externally.
 * Also, add this shortcut to IQueryContextCommon in @comunica/types.
 */
export declare const KeysCore: {
    /**
     * A logger instance.
     */
    log: ActionContextKey<import("@comunica/types").Logger>;
};
export declare const KeysHttp: {
    /**
     * Include credentials flags.
     */
    includeCredentials: ActionContextKey<boolean>;
    /**
     * Authentication for a source as a "username:password"-pair.
     */
    auth: ActionContextKey<string>;
    /**
     * Fetch function implementation.
     */
    fetch: ActionContextKey<typeof fetch>;
    /**
     * HTTP request timeout in milliseconds.
     */
    httpTimeout: ActionContextKey<number>;
    /**
     * Makes the HTTP timeout not only apply until the response starts streaming in
     * but until the response is fully consumed.
     */
    httpBodyTimeout: ActionContextKey<boolean>;
    /**
     * Number of retries to make on failed network calls. This only takes effect
     * on errors thrown during the initial fetch() call and not while streaming the body.
     */
    httpRetryCount: ActionContextKey<number>;
    /**
     * Delay in milliseconds to wait between fetch retries. Requires httpRetryCount to be set.
     */
    httpRetryDelay: ActionContextKey<number>;
    /**
     * Retry fetch, if server replies with a 5xx error response. Requires httpRetryCount to be set.
     */
    httpRetryOnServerError: ActionContextKey<number>;
};
export declare const KeysHttpWayback: {
    /**
     * Use the WayBack machine to get the most recent representation of a file if a link is broken.
     * @default false
     */
    recoverBrokenLinks: ActionContextKey<boolean>;
};
export declare const KeysHttpMemento: {
    /**
     * The desired datetime for Memento datetime-negotiation.
     */
    datetime: ActionContextKey<Date>;
};
export declare const KeysHttpProxy: {
    /**
     * Interface.
     */
    httpProxyHandler: ActionContextKey<IProxyHandler>;
};
export declare const KeysInitQuery: {
    /**
     * Variables that have to be pre-bound to values in the query.
     */
    initialBindings: ActionContextKey<RDF.Bindings>;
    /**
     * The provided query's format.
     * Defaults to { language: 'sparql', version: '1.1' }
     */
    queryFormat: ActionContextKey<RDF.QueryFormat>;
    /**
     * Which GraphQL bindings should be singularized.
     */
    graphqlSingularizeVariables: ActionContextKey<any>;
    /**
     * If HTTP and parsing failures are ignored.
     */
    lenient: ActionContextKey<boolean>;
    /**
     * The original query string.
     */
    queryString: ActionContextKey<string>;
    /**
     * The original parsed query.
     */
    query: ActionContextKey<Algebra.Operation>;
    /**
     * The query's base IRI.
     */
    baseIRI: ActionContextKey<string>;
    /**
     * A timestamp representing the current time.
     *                 This is required for certain SPARQL operations such as NOW().
     */
    queryTimestamp: ActionContextKey<Date>;
    /**
     * @range {functionNamedNode: RDF.NamedNode) => ((args: RDF.Term[]) => Promise<RDF.Term>) | undefined}
     * Extension function creator for a given function IRI.
     * Returned value should be an async function implementation.
     * Undefined may be returned if no implementation exists for the given function IRI.
     *
     * The dictionary-based extensionFunctions context entry may be used instead, but not simultaneously.
     */
    extensionFunctionCreator: ActionContextKey<(functionNamedNode: RDF.NamedNode) => ((args: RDF.Term[]) => Promise<RDF.Term>) | undefined>;
    /**
     * Dictionary of extension functions.
     * Key is the IRI of the function, and value is the async function implementation.
     *
     * The callback-based extensionFunctionCreator context entry may be used instead, but not simultaneously.
     */
    extensionFunctions: ActionContextKey<Record<string, (args: RDF.Term[]) => Promise<RDF.Term>>>;
    /**
     * Enables manipulation of the CLI arguments and their processing.
     */
    cliArgsHandlers: ActionContextKey<ICliArgsHandler[]>;
    /**
     * Explain mode of the query. Can be 'parsed', 'logical', or 'physical'.
     */
    explain: ActionContextKey<QueryExplainMode>;
    /**
     * Logs the used physical operators
     */
    physicalQueryPlanLogger: ActionContextKey<IPhysicalQueryPlanLogger>;
    /**
     * The current physical operator within the query plan.
     *              This is used to pass parent-child relationships for invoking the query plan logger.
     */
    physicalQueryPlanNode: ActionContextKey<any>;
    /**
     * A JSON-LD context
     */
    jsonLdContext: ActionContextKey<any>;
};
export declare const KeysQueryOperation: {
    /**
     * Context entry for the current query operation.
     */
    operation: ActionContextKey<string>;
    /**
     * @type {any} The metadata from the left streams within a join operation.
     */
    joinLeftMetadata: ActionContextKey<MetadataBindings>;
    /**
     * An array of metadata from the right streams within a join operation.
     */
    joinRightMetadatas: ActionContextKey<MetadataBindings[]>;
    /**
     * Indicates the bindings that were used to bind the operation.
     */
    joinBindings: ActionContextKey<RDF.Bindings>;
    /**
     * Flag for indicating that only read operations are allowed, defaults to false.
     */
    readOnly: ActionContextKey<boolean>;
    /**
     * An internal context entry to mark that a property path with arbitrary length and a distinct key is being processed.
     */
    isPathArbitraryLengthDistinctKey: ActionContextKey<boolean>;
    /**
     * An indicator that the stream will be limited to the given number of elements afterwards.
     */
    limitIndicator: ActionContextKey<number>;
    /**
     * If the default graph should also contain the union of all named graphs.
     */
    unionDefaultGraph: ActionContextKey<boolean>;
    /**
     * An indicator that the operator should apply blank node localization
     */
    localizeBlankNodes: ActionContextKey<boolean>;
};
export declare const KeysRdfParseJsonLd: {
    /**
     * @range {IDocumentLoader}
     */
    documentLoader: ActionContextKey<IDocumentLoader>;
    /**
     * @range {boolean}
     */
    strictValues: ActionContextKey<boolean>;
    /**
     * @range {Record<string, any>}
     */
    parserOptions: ActionContextKey<Record<string, any>>;
};
export declare const KeysRdfParseHtmlScript: {
    /**
     * An internal context flag to determine if the engine is already processing an HTML script tag.
     */
    processingHtmlScript: ActionContextKey<boolean>;
    /**
     * If all HTML script tags must be considered.
     */
    extractAllScripts: ActionContextKey<boolean>;
};
export declare const KeysRdfResolveQuadPattern: {
    /**
     * Data sources.
     */
    sources: ActionContextKey<DataSources>;
    /**
     * A data source.
     */
    source: ActionContextKey<IDataSource>;
    /**
     * A map containing unique IDs for each source
     */
    sourceIds: ActionContextKey<Map<IDataSource, string>>;
};
export declare const KeysRdfUpdateQuads: {
    /**
     * A data destination.
     */
    destination: ActionContextKey<IDataDestination>;
};
