"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@comunica/core");
/**
 * A comunica mediator that runs all actors that resolve their test.
 * This mediator will always resolve to `null`.
 */
class MediatorAll extends core_1.Mediator {
    constructor(args) {
        super(args);
    }
    async mediate(action) {
        // Collect all actors that resolve their test
        const validActors = [];
        let testResults;
        try {
            testResults = this.publish(action);
        }
        catch (e) {
            testResults = [];
        }
        for (const testResult of testResults) {
            try {
                await testResult.reply;
                validActors.push(testResult.actor);
            }
            catch (e) {
                // Ignore errors
            }
        }
        // Send action to all valid actors
        await Promise.all(validActors.map((actor) => actor.runObservable(action)));
        return null;
    }
    async mediateWith(action, testResults) {
        return null;
    }
}
exports.MediatorAll = MediatorAll;
//# sourceMappingURL=MediatorAll.js.map