"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@comunica/core");
/**
 * A comunica mediator that takes the union of all actor results.
 *
 * The actors that are registered first will have priority on setting overlapping fields.
 */
class MediatorCombineUnion extends core_1.Mediator {
    constructor(args) {
        super(args);
        this.combiner = this.createCombiner();
    }
    async mediate(action) {
        const testResults = this.publish(action);
        // Delegate test errors.
        await Promise.all(require('lodash.map')(testResults, 'reply'));
        // Run action on all actors.
        const results = await Promise.all(testResults.map((result) => result.actor.runObservable(action)));
        // Return the combined results.
        return this.combiner(results);
    }
    mediateWith(action, testResults) {
        throw new Error("Method not supported.");
    }
    createCombiner() {
        return (results) => {
            const data = {};
            data[this.field] = require('lodash.defaults').apply({}, [{}].concat(require('lodash.map')(results, this.field)));
            return data;
        };
    }
}
exports.MediatorCombineUnion = MediatorCombineUnion;
//# sourceMappingURL=MediatorCombineUnion.js.map