#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const componentsjs_1 = require("componentsjs");
const fs_1 = require("fs");
const path_1 = require("path");
const args = process.argv.slice(2);
if (!args.length) {
    console.error('Usage: comunica-compile-config path/to/config.json [urn:of:init:actor]');
    process.exit(1);
}
const mainModulePath = process.cwd();
const configResourceUri = 'urn:comunica:my';
const configPath = args[0];
const configStreamRaw = fs_1.createReadStream(configPath, { encoding: 'utf8' });
let exportVariableName = 'urn:comunica:sparqlinit';
if (args.length > 1) {
    exportVariableName = args[1];
}
// Hack our require path so that compilation in a monorepo dev environment always works properly
// Otherwise, Components.js will think that we are running inside the 'runner' package,
// and it will use its node_modules.
require.main.paths = [];
const pathParts = mainModulePath.split(path_1.sep);
for (let i = pathParts.length; i > 0; i--) {
    require.main.paths.push(pathParts.slice(0, i).join(path_1.sep) + path_1.sep + 'node_modules');
}
componentsjs_1.compileConfig({ mainModulePath }, configPath, configStreamRaw, configResourceUri, exportVariableName)
    .then(console.log).catch((e) => {
    console.error(e);
    process.exit(1);
});
//# sourceMappingURL=compile-config.js.map