import { IActionInit } from "@comunica/bus-init";
import { LoaderProperties } from "componentsjs";
/**
 * Helper class to setup instances from a given comunica config file.
 * This config file must be understandable by the Components.js framework.
 *
 * @link https://www.npmjs.com/package/lsd-components
 */
export declare class Setup {
    private constructor();
    /**
     * Run the given config file.
     * This will initialize the runner, and deinitialize it once it has finished
     *
     * @param {string} configResourceUrl    The URL or local path to a Components.js config file.
     * @param {any[]} action                The action to pass to the runner.
     * @param {string} runnerUri            An optional URI identifying the runner.
     * @param {LoaderProperties} properties Properties to pass to the Components.js loader.
     * @return {Promise<any>}               A promise that resolves when the runner has been initialized.
     */
    static run(configResourceUrl: string, action: IActionInit, runnerUri?: string, properties?: ISetupProperties): Promise<any>;
    /**
     * Instantiate the given component.
     *
     * @param {string} configResourceUrl    The URL or local path to a Components.js config file.
     * @param {string} instanceUri          A URI identifying the component to instantiate.
     * @param {any[]}  action               The action to pass to the runner.
     * @param {LoaderProperties} properties Properties to pass to the Components.js loader.
     * @return {Promise<any>}               A promise that resolves to the instance.
     */
    static instantiateComponent(configResourceUrl: string, instanceUri: string, action: IActionInit, properties?: ISetupProperties): Promise<any>;
}
export declare type ISetupProperties = LoaderProperties;
