import { createContext, useMemo, createElement, useContext } from 'react';

var isDev = process.env.NODE_ENV !== "production";
var NO_PROVIDER = "_NP_";

function createUseContext(context) {
  return function () {
    var value = useContext(context);

    if (isDev && value === NO_PROVIDER) {
      // eslint-disable-next-line no-console
      console.warn("[constate] Component not wrapped within a Provider.");
    }

    return value;
  };
}

function constate(useValue) {
  for (var _len = arguments.length, splitValues = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    splitValues[_key - 1] = arguments[_key];
  }

  var Context = createContext(NO_PROVIDER);

  var Provider = function Provider(props) {
    var value = useValue(props);
    var createMemoDeps = splitValues[0];
    var deps = createMemoDeps && createMemoDeps(value);

    if (isDev && Array.isArray(deps)) {
      // eslint-disable-next-line no-console
      console.warn("[constate] Passing `createMemoDeps` as the second argument is deprecated.", "Please, use `React.useMemo` in your custom hook instead.", "See https://github.com/diegohaz/constate/issues/98");
    } // deps won't change between renders


    var memoizedValue = Array.isArray(deps) ? useMemo(function () {
      return value;
    }, deps) : value;
    return createElement(Context.Provider, {
      value: memoizedValue
    }, props.children);
  };

  if (isDev && useValue.name) {
    Context.displayName = useValue.name + ".Context";
    Provider.displayName = useValue.name + ".Provider";
  } // const useCounterContext = constate(...)


  var useContext = createUseContext(Context); // const { Context, Provider } = constate(...)

  useContext.Context = Context;
  useContext.Provider = Provider;
  var tuple = [];

  if (!splitValues.length) {
    // const [Provider, useCounterContext] = constate(...);
    tuple.push(Provider, createUseContext(Context));
  } else {
    var contexts = [];

    var SplitProvider = function SplitProvider(props) {
      var value = useValue(props);
      var children = props.children;

      for (var i = 0; i < contexts.length; i += 1) {
        var context = contexts[i]; // splitValue may be a hook, but it won't change between re-renders

        var splitValue = splitValues[i];
        children = createElement(context.Provider, {
          value: splitValue(value)
        }, children);
      }

      return children;
    };

    if (isDev && useValue.name) {
      SplitProvider.displayName = useValue.name + ".Provider";
    } // const [Provider, useCount, useIncrement] = constate(...);


    tuple.push(SplitProvider);

    for (var i = 0; i < splitValues.length; i += 1) {
      var context = createContext(NO_PROVIDER);
      contexts.push(context);
      tuple.push(createUseContext(context));
    }
  }

  for (var _i = 0; _i < tuple.length; _i += 1) {
    useContext[_i] = tuple[_i];
  }

  if (typeof Symbol === "function" && Symbol.iterator) {
    useContext[Symbol.iterator] =
    /* istanbul ignore next */
    function () {
      return tuple[Symbol.iterator]();
    };
  }

  return useContext;
}

export default constate;
