import m from 'mithril';
import { IAttrs, ISizeAttrs, IIntentAttrs } from '../..';
export interface IInputFileAttrs extends IAttrs, ISizeAttrs, IIntentAttrs {
    /** Left-justified content */
    contentLeft?: m.Vnode<any, any>;
    /** Right-justified content */
    contentRight?: m.Vnode<any, any>;
    /** Disables file selection */
    disabled?: boolean;
    /** Fills width of parent container */
    fluid?: boolean;
    /** Callback invoked on filename change */
    onchange?: (e: Event) => void;
    /** Inner text value */
    text?: string;
    [htmlAttrs: string]: any;
}
export declare class InputFile implements m.Component<IInputFileAttrs> {
    private browseButton;
    oncreate(vnode: m.VnodeDOM<IInputFileAttrs>): void;
    onupdate(vnode: m.VnodeDOM<IInputFileAttrs>): void;
    view({ attrs }: m.Vnode<IInputFileAttrs>): m.Vnode<any, any>;
    private updatePadding;
}
