import m from 'mithril';
import { IAttrs, ISizeAttrs, IIntentAttrs } from '../../_shared';
export interface IInputAttrs extends IAttrs, ISizeAttrs, IIntentAttrs {
    /** Toggles basic styling (only bottom border) */
    basic?: boolean;
    /** Left-justified content */
    contentLeft?: m.Vnode<any, any>;
    /** Right-justified content */
    contentRight?: m.Vnode<any, any>;
    /** Initial value to display (uncontrolled mode) */
    defaultValue?: string;
    /** Disables input */
    disabled?: boolean;
    /** Fills width of parent container */
    fluid?: boolean;
    /** Callback invoked on value change */
    onchange?: (e: Event) => void;
    /** Input value */
    value?: string | number;
    [htmlAttrs: string]: any;
}
export declare class Input implements m.Component<IInputAttrs> {
    oncreate(vnode: m.VnodeDOM<IInputAttrs>): void;
    onupdate(vnode: m.VnodeDOM<IInputAttrs>): void;
    view({ attrs }: m.Vnode<IInputAttrs>): m.Vnode<any, any>;
    private updatePadding;
}
