import m from 'mithril';
import { IAttrs } from '../../_shared';
import { AbstractComponent } from '../abstract-component';
import { IPortalAttrs } from '../portal';
export interface IOverlayableAttrs {
    /** Class added to backdrop element */
    backdropClass?: string;
    /** Whether component can be closed on outer click */
    closeOnOutsideClick?: boolean;
    /**
     * Whether component can be closed on Escape key
     * @default true
     */
    closeOnEscapeKey?: boolean;
    /** Whether to show backdrop element */
    hasBackdrop?: boolean;
    /** Renders component relative to parent container */
    inline?: boolean;
    /**
     * Callback invoked on initial close
     * Passes back event that triggered close
     */
    onClose?: (e: Event) => void;
    /** Callback invoked after transition is complete and component is unmounted */
    onClosed?: () => void;
    /**
     * Callback invoked when component mounts and transition is complete
     * Passes back DOM element container
     */
    onOpened?: (contentEl: HTMLElement) => void;
    /** Sets focus to first element that has a `autofocus` or `tabindex` attribute */
    autofocus?: boolean;
    /** Wether last active element should be focused on close  */
    restoreFocus?: boolean;
    /**
     * Wether overlay should be added to the "open" stack.
     * When <code>true</code>, overlays will be stacked on top of one another
     * and will close in sequence.
     */
    addToStack?: boolean;
    /** Attrs passed through to the Portal component */
    portalAttrs?: IPortalAttrs;
    /**
     * Name of transition. The name is used to apply CSS transition classes on open and close.
     * On open, ${name}-enter and ${name}-enter-active are added. On close, ${name}-exit
     * and ${name}-exit-active are added.
     * @default 'fade'
     */
    transitionName?: string;
    /**
     * Duration of the animation. Note: the CSS transition duration must match the
     * custom duration passed to this component
     * @default 200
     */
    transitionDuration?: number;
}
export interface IOverlayAttrs extends IOverlayableAttrs, IAttrs {
    /** Inner content */
    content?: m.Children;
    /** Toggles overlay visibility */
    isOpen?: boolean;
}
export declare class Overlay extends AbstractComponent<IOverlayAttrs> {
    private id;
    private shouldRender;
    private contentEl;
    private lastActiveElement;
    private static openStack;
    private static getLastOpened;
    getDefaultAttrs(): {
        closeOnEscapeKey: boolean;
        closeOnOutsideClick: boolean;
        hasBackdrop: boolean;
        addToStack: boolean;
        transitionName: string;
        transitionDuration: number;
    };
    oninit(vnode: m.Vnode<IOverlayAttrs>): void;
    onbeforeupdate(vnode: m.Vnode<IOverlayAttrs>, old: m.VnodeDOM<IOverlayAttrs>): void;
    onremove(): void;
    view(): m.Vnode<any, any> | null;
    private onContainerCreate;
    private onContainerUpdate;
    private handleOpen;
    private handleClose;
    private handleClosed;
    private handleEnterTransition;
    private handleExitTransition;
    private handleFocus;
    private handleBackdropMouseDown;
    private handleDocumentMouseDown;
    private handleKeyDown;
    private readonly lastOpened;
}
