"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var mithril_1 = tslib_1.__importDefault(require("mithril"));
var _shared_1 = require("../../_shared");
var enquirejs;
if (typeof window !== 'undefined') {
    var matchMediaPolyfill = function (mediaQuery) {
        return {
            media: mediaQuery,
            matches: false,
            // tslint:disable-next-line:no-empty
            addListener: function () {
            },
            // tslint:disable-next-line:no-empty
            removeListener: function () {
            }
        };
    };
    window.matchMedia = window.matchMedia || matchMediaPolyfill;
    // tslint:disable-next-line:no-var-requires
    enquirejs = require('enquire.js');
}
var breakpointKeys = Object.keys(_shared_1.Breakpoints);
var ResponsiveManager = /** @class */ (function () {
    function ResponsiveManager() {
        this.isInitialized = false;
    }
    /** Binds initial breakpoints */
    ResponsiveManager.prototype.initialize = function () {
        var _this = this;
        if (this.isInitialized) {
            return;
        }
        breakpointKeys.map(function (breakpoint) { return enquirejs.register(_shared_1.Breakpoints[breakpoint], {
            match: function () {
                var _a;
                _this.breakpoints = tslib_1.__assign({}, _this.breakpoints, (_a = {}, _a[breakpoint] = true, _a));
                mithril_1.default.redraw();
            },
            unmatch: function () {
                var _a;
                _this.breakpoints = tslib_1.__assign({}, _this.breakpoints, (_a = {}, _a[breakpoint] = false, _a));
                mithril_1.default.redraw();
            },
            // tslint:disable-next-line:no-empty
            destroy: function () { }
        }); });
        this.isInitialized = true;
    };
    /** Checks if current breakpoint string is active */
    ResponsiveManager.prototype.is = function (key) {
        return this.breakpoints[key] === true;
    };
    /** Unbinds all breakpoints */
    ResponsiveManager.prototype.destroy = function () {
        breakpointKeys.map(function (breakpoint) { return enquirejs.unregister(_shared_1.Breakpoints[breakpoint]); });
    };
    return ResponsiveManager;
}());
exports.default = new ResponsiveManager();
