import * as tslib_1 from "tslib";
import m from 'mithril';
import classnames from 'classnames';
import { Classes, getClosest, safeCall } from '../../_shared';
import { isFunction } from 'util';
var ListItem = /** @class */ (function () {
    function ListItem() {
    }
    ListItem.prototype.view = function (_a) {
        var _this = this;
        var attrs = _a.attrs;
        var active = attrs.active, className = attrs.class, contentLeft = attrs.contentLeft, contentRight = attrs.contentRight, disabled = attrs.disabled, selected = attrs.selected, label = attrs.label, onclick = attrs.onclick, htmlAttrs = tslib_1.__rest(attrs, ["active", "class", "contentLeft", "contentRight", "disabled", "selected", "label", "onclick"]);
        var classes = classnames(Classes.LIST_ITEM, active && Classes.ACTIVE, disabled && Classes.DISABLED, selected && Classes.SELECTED, className);
        var content = [
            contentLeft && m("." + Classes.LIST_ITEM_CONTENT_LEFT, contentLeft),
            label,
            contentRight && m("." + Classes.LIST_ITEM_CONTENT_RIGHT, contentRight)
        ];
        return m('', tslib_1.__assign({}, htmlAttrs, { class: classes, onclick: function (e) { return _this.handleClick(e, onclick); } }), content);
    };
    ListItem.prototype.handleClick = function (e, onclick) {
        var el = e.target;
        var isClickOnLeftContent = getClosest(el, "." + Classes.LIST_ITEM_CONTENT_LEFT);
        var isClickOnRightContent = getClosest(el, "." + Classes.LIST_ITEM_CONTENT_RIGHT);
        if (isFunction(onclick) && !isClickOnLeftContent && !isClickOnRightContent) {
            safeCall(onclick, e);
        }
        else
            e.redraw = false;
    };
    return ListItem;
}());
export { ListItem };
