import m from 'mithril';
import { IAttrs } from '../../_shared';
import { AbstractComponent } from '../abstract-component';
import { IListAttrs } from '../list';
import { IInputAttrs } from '../input';
import { IControlGroupAttrs } from '../control-group';
export interface IQueryListEvents {
    handleKeyDown: (e: KeyboardEvent) => void;
}
export interface IFilterableAttrs {
    /**
     * Attrs passed through to the ControlGroup component
     * @default {}
     */
    controlGroupAttrs?: IControlGroupAttrs;
    /** Right-justified content in relation to Input component  */
    contentRight?: m.Children;
    /** Left-justified content in relation to Input component  */
    contentLeft?: m.Children;
    /** Initial query value (uncontrolled mode) */
    defaultQuery?: string;
    /**
     * Toggles search input
     * @default true
     */
    filterable?: boolean;
    /** Callback invoked on input query change; only called when `query` is defined */
    onQueryChange?: (query: string) => void;
    /** Input query value (controlled mode) */
    query?: string;
}
export interface IQueryableAttrs<T> extends IAttrs {
    /** Current index position (controlled mode)  */
    activeIndex?: number;
    /**
     * When true, items will be "cached" when a query is specified.
     * When false, every redraw will call itemPredicate or itemListPredicate if a query is specified
     * @default true
     */
    cacheItems?: boolean;
    /**
     * Wether to show a checkmark for selected item(s)
     * @default true
     */
    checkmark?: boolean;
    /** Initial active index (uncontrolled mode)  */
    defaultActiveIndex?: number;
    /**
     * Content rendered when input query is empty. If defined, items will only be rendered
     * when a search query is provided.
     */
    initialContent?: m.Children;
    /**
     * Attrs passed through to Input component.
     * @default {}
     */
    inputAttrs?: IInputAttrs;
    /**
     * Custom render function for the entire list. If undefined, returns a List
     * component that calls `itemRender` for each item.
     */
    itemListRender?: (items: T[]) => m.Vnode;
    /**
     * Predicate function used to filter all items.
     * Takes predecent over `itemPredicate`
     */
    itemListPredicate?: (query: string, items: T[]) => T[];
    /** Render function applied to each item  */
    itemRender: (item: T, index: number) => m.Vnode<any, any>;
    /** Predicate function applied to filter individual items  */
    itemPredicate?: (query: string, item: T, index: number) => boolean;
    /** Array of T items */
    items: T[];
    /**
     * Element(s) shown when input query returns empty
     * @default 'No items available'
     */
    emptyContent?: m.Children;
    /** Callback invoked on active item change; only called when `activeIndex` is defined */
    onActiveItemChange?: (activeItem: T, index: number) => void;
    /** Callback invoked when child item is clicked */
    onSelect?: (item: T, e: Event, index: number) => void;
    /**
     * Attrs passed through to List component
     * @default {}
     */
    listAttrs?: IListAttrs;
    eventCallbacks?: (events: IQueryListEvents) => void;
}
export interface IQueryListAttrs<T> extends IQueryableAttrs<T>, IFilterableAttrs {
}
export declare class QueryList<T> extends AbstractComponent<IQueryListAttrs<T>> {
    private filteredItems;
    private activeIndex;
    private itemNodes;
    private inputEl;
    private query;
    private listEl;
    static ofType<T>(): new () => QueryList<T>;
    getDefaultAttrs(): IQueryListAttrs<T>;
    oninit(vnode: m.Vnode<IQueryListAttrs<T>>): void;
    oncreate({ dom }: m.VnodeDOM<IQueryListAttrs<T>>): void;
    onbeforeupdate(vnode: m.Vnode<IQueryListAttrs<T>>, old: m.VnodeDOM<IQueryListAttrs<T>>): void;
    view(): m.Vnode<any, any>;
    private renderControlGroup;
    private renderList;
    private renderItem;
    private setControlledAttrs;
    scrollToActiveItem(): void;
    private readonly activeItem;
    private updateQuery;
    private handleInput;
    private handleSearchDebounce;
    private handleInputClear;
    private handleSelect;
    private handleKeyDown;
    private moveActiveIndex;
    private updateActiveIndex;
    private handleEnterKey;
    private getFilteredItems;
}
