import m from 'mithril';
import { IPopoverAttrs } from '../popover';
import { AbstractComponent } from '../abstract-component';
import { QueryList, IQueryListAttrs } from '../query-list';
export interface ISelectListAttrs<T> extends IQueryListAttrs<T> {
    /**
     * Closes popover on item select
     * @default true
     */
    closeOnSelect?: boolean;
    /**
     * Attrs passed through to Popover component
     * @default {}
     */
    popoverAttrs?: Partial<IPopoverAttrs>;
    /** Trigger element */
    trigger: m.Vnode<any, any>;
    /** Header content */
    header?: m.Children;
    /** Footer content */
    footer?: m.Children;
    /** Toggles loading state of inner list */
    loading?: boolean;
}
export declare class SelectList<T> extends AbstractComponent<ISelectListAttrs<T>> {
    queryList: new () => QueryList<T>;
    private isOpen;
    private activeIndex;
    static ofType<T>(): new () => SelectList<T>;
    getDefaultAttrs(): ISelectListAttrs<T>;
    oninit(vnode: m.Vnode<ISelectListAttrs<T>>): void;
    onbeforeupdate(vnode: m.Vnode<ISelectListAttrs<T>>, old: m.VnodeDOM<ISelectListAttrs<T>>): void;
    view(): m.Vnode<IPopoverAttrs, unknown>;
    private handleActiveItemChange;
    private handleSelect;
    private handlePopoverInteraction;
}
