import m from 'mithril';
import { IActionItemAttrs, IAttrs, ISizeAttrs, IIntentAttrs, Align } from '../../_shared';
export interface IButtonAttrs extends IAttrs, IActionItemAttrs, ISizeAttrs, IIntentAttrs {
    /**
     * Content alignment; Used to align left/right icon when fluid=true
     * @default 'center'
     */
    align?: Align;
    /** Toggles basic styling (no borders/background) */
    basic?: boolean;
    /** Reduces horizontal padding */
    compact?: boolean;
    /** Sets anchor tag URL (anchor button only) */
    href?: string;
    /** Toggles loading animation */
    loading?: boolean;
    /** Toggles rounded styling */
    rounded?: boolean;
    /** Fills width of parent container */
    fluid?: boolean;
    /** Toggles outlined styling */
    outlined?: boolean;
    /** Sublabel */
    sublabel?: m.Child;
    [htmlAttrs: string]: any;
}
export declare class Button implements m.Component<IButtonAttrs> {
    view({ attrs }: m.Vnode<IButtonAttrs>): m.Vnode<any, any>;
}
