import m from 'mithril';
import { IAttrs, ISizeAttrs, IIntentAttrs } from '../../_shared';
import { Icons } from './generated';
export declare type IconName = (typeof Icons)[keyof typeof Icons];
export interface IIconAttrs extends IAttrs, ISizeAttrs, IIntentAttrs {
    /** Icon name */
    name: IconName;
    /** Callback invoked on click; Passing this attr will apply hover styles to the icon */
    onclick?: (e: Event) => void;
    [htmlAttrs: string]: any;
}
export declare class Icon implements m.Component<IIconAttrs> {
    view({ attrs }: m.Vnode<IIconAttrs>): m.Vnode<any, any>;
}
