import m from 'mithril';
import { AbstractComponent } from '../abstract-component';
import { IInputAttrs } from '../input';
import { IButtonAttrs } from '../button';
import { IPopoverAttrs } from '../popover';
export interface IInputPopoverAttrs extends Omit<IPopoverAttrs, 'content'> {
    /**
     * Attrs passed through to wrapper container
     * @default {}
     */
    contentAttrs?: any;
    /** Initial value to display */
    value?: string;
    /** Elements added before content */
    header?: m.Children;
    /** Elements added after content */
    footer?: m.Children;
    /** Whether to highlight input text on open */
    hightlightOnOpen?: boolean;
    /**
     * Attrs passed through to input/textarea element
     * @default {}
     */
    inputAttrs?: IInputAttrs;
    /**
     * Type of input to render
     * @default 'input'
     */
    type?: 'input' | 'textarea';
    /** Placeholder value for input  */
    placeholder?: string;
    /**
     * Callback invoked when submit button is clicked
     * (or if type="input", submitOnEnter="true" and ENTER key is pressed)
     */
    onSubmit: (value: string) => void;
    /**
     * Attrs passed through to submit button
     * @default {}
     */
    submitButtonAttrs?: IButtonAttrs;
    /**
     * Label for submit button
     * @default 'Submit'
     */
    submitButtonLabel?: m.Children;
    /**
     * Whether onSubmit is called on ENTER key
     * Note: only applies to type="input" element
     * @default true
     */
    submitOnEnter?: boolean;
}
export declare class InputPopover extends AbstractComponent<IInputPopoverAttrs> {
    private value;
    getDefaultAttrs(): IInputPopoverAttrs;
    oninit(vnode: m.Vnode<IInputPopoverAttrs>): void;
    view(): m.Vnode<IPopoverAttrs, unknown>;
    private renderInput;
    private handleOnKeyDown;
    private handleOnSubmit;
    private handleOnOpened;
    private handleOnClosed;
}
