import m from 'mithril';
import { AbstractComponent } from '../abstract-component';
import { IQueryableAttrs } from '../query-list';
import { IPopoverAttrs } from '../popover';
export interface IInputSelectAttrs<T> extends IQueryableAttrs<T> {
    /**
     * Closes popover on item select
     * @default true
     */
    closeOnSelect?: boolean;
    /**
     * Attrs passed through to Popover component
     * @default {}
     */
    popoverAttrs?: Partial<IPopoverAttrs>;
    /** Header content */
    header?: m.Children;
    /** Footer content */
    footer?: m.Children;
    /** Toggles loading state of inner list */
    loading?: boolean;
    /** Input value;  */
    value?: number | string;
    /**
     * Opens popover on input down key
     * @default true
     */
    openOnDownKey?: boolean;
}
export declare class InputSelect<T> extends AbstractComponent<IInputSelectAttrs<T>> {
    private queryList;
    private isOpen;
    private query;
    private input;
    private activeIndex;
    private handleQueryListKeyDown;
    getDefaultAttrs(): IInputSelectAttrs<T>;
    static ofType<T>(): new () => InputSelect<T>;
    oninit(vnode: m.Vnode<IInputSelectAttrs<T>>): void;
    onbeforeupdate(vnode: m.Vnode<IInputSelectAttrs<T>>, old: m.VnodeDOM<IInputSelectAttrs<T>>): void;
    view(): m.Vnode<IPopoverAttrs, unknown>;
    private handleInput;
    private handleInputFocus;
    private handleInputKeyDown;
    private handleSearchDebounce;
    private handleActiveItemChange;
    private handleSelect;
    private handlePopoverInteraction;
    private handlePopoverClosed;
    private readonly inputEl;
}
