import m from 'mithril';
import { IAttrs } from '../../_shared';
export interface IListItemAttrs extends IAttrs {
    /** Toggles active state */
    active?: boolean;
    /** Left-justified content */
    contentLeft?: m.Children;
    /** Right-justified content */
    contentRight?: m.Children;
    /** Toggles disabled state */
    disabled?: boolean;
    /** Toggles selected state */
    selected?: boolean;
    /** Inner text or content */
    label?: m.Children;
    /** Callback invoked on click */
    onclick?: (e: Event) => void;
    [htmlAttrs: string]: any;
}
export declare class ListItem implements m.Component<IListItemAttrs> {
    view({ attrs }: m.Vnode<IListItemAttrs>): m.Vnode<any, any>;
    private handleClick;
}
