import m from 'mithril';
import { IAttrs, ISizeAttrs, Option } from '../../_shared';
export interface IRadioGroupAttrs extends IAttrs, ISizeAttrs {
    /** Disables selection */
    disabled?: boolean;
    /**
     * Name of the radio group.
     * If no name is specified, a unique name will be generated for each instance.
     */
    name?: string;
    /**
     * Callback invoked when selection changes.
     * The selected value can be accessed through <code>e.currentTarget.value</code>
     */
    onchange?: (e: Event) => void;
    /** Array of radio group options */
    options?: Option[];
    /** Value of the selected radio element */
    value?: string;
    [htmlAttrs: string]: any;
}
export declare class RadioGroup implements m.Component<IRadioGroupAttrs> {
    private uniqueId;
    view({ attrs }: m.Vnode<IRadioGroupAttrs>): m.Vnode<any, any>;
    private renderRadioButton;
}
