import m from 'mithril';
import { IAttrs, ISizeAttrs, IIntentAttrs } from '../../_shared';
import { AbstractComponent } from '../abstract-component';
import { IconName } from '../icon';
export interface IToastAttrs extends IAttrs, ISizeAttrs, IIntentAttrs {
    /** Left-justified icon */
    icon?: IconName;
    /** Inner content message */
    message?: m.Children;
    /** Callback invoked when toast is dismissed or timeout expires */
    onDismiss?: (key: number | string, timedOut: boolean) => void;
    /**
     * Duration of dismiss timeout;
     * A value of `0` will prevent the toast from timing out
     * @default 3000
     */
    timeout?: number;
    /** Toast key; necessary when used in controlled mode */
    key?: number | string;
    [htmlAttrs: string]: any;
}
export declare class Toast extends AbstractComponent<IToastAttrs> {
    getDefaultAttrs(): {
        timeout: number;
    };
    oncreate(): void;
    onbeforeupdate(vnode: m.Vnode<IToastAttrs>, prev: m.VnodeDOM<IToastAttrs>): void;
    view(): m.Vnode<any, any>;
    onremove(): void;
    private handleCloseClick;
    private triggerDismiss;
    private startTimeout;
}
