import m from 'mithril';
import { IAttrs } from '../../_shared';
import { AbstractComponent } from '../abstract-component';
import { IToastAttrs } from './Toast';
export declare type IToastOptions = IToastAttrs & {
    key?: string;
};
export declare const ToasterPosition: {
    TOP: "top";
    TOP_START: "top-start";
    TOP_END: "top-end";
    BOTTOM: "bottom";
    BOTTOM_START: "bottom-start";
    BOTTOM_END: "bottom-end";
};
export declare type ToasterPosition = typeof ToasterPosition[keyof typeof ToasterPosition];
export interface IToaster {
    /** Show toast */
    show(attrs: IToastAttrs): string;
    /** Update toast attrs by key */
    update(key: string, attrs: IToastAttrs): void;
    /** Dismiss toast by key */
    dismiss(key: string): void;
    /** Clear all toasts */
    clear(): void;
    /** Get array of toasts */
    getToasts(): IToastOptions[];
}
export interface IToasterAttrs extends IAttrs {
    /**
     *  Clears all toasts on ESCAPE key
     * @default true
     */
    clearOnEscapeKey?: boolean;
    /** Renders component relative to parent container */
    inline?: boolean;
    /**
     * Position of each toast item
     * @default 'top'
     */
    position?: ToasterPosition;
    /** Array of `Toast` items when used in declarative mode */
    toasts?: Array<m.Vnode<IToastAttrs, any>>;
}
export declare class Toaster extends AbstractComponent<IToasterAttrs> {
    private toasts;
    private toastId;
    getDefaultAttrs(): IToasterAttrs;
    view(): m.Vnode<import("../overlay").IOverlayAttrs, unknown>;
    onremove(): void;
    show(attrs: IToastAttrs): string;
    update(key: string | number, attrs: IToastOptions): void;
    dismiss: (key: string | number, timedOut?: boolean) => void;
    clear(): void;
    getToasts(): IToastOptions[];
    private renderToast;
    private isControlled;
}
