import m from 'mithril';
import { IAttrs, ISizeAttrs, IIntentAttrs } from '../../_shared';
export interface IControlAttrs extends IAttrs, ISizeAttrs, IIntentAttrs {
    /** Toggles checked state */
    checked?: boolean;
    /**
     * Attrs passed through to container element
     */
    containerAttrs?: any;
    /** Initially sets control to checked state (uncontrolled mode) */
    defaultChecked?: boolean;
    /** Disables interaction */
    disabled?: boolean;
    /** Text label */
    label?: m.Children;
    /** Callback invoked on control change */
    onchange?: (e: Event) => void;
    /** Disables interaction but maintains styling */
    readonly?: boolean;
    type?: 'checkbox' | 'radio';
    typeClass?: string;
    [htmlAttrs: string]: any;
}
export declare class BaseControl implements m.Component<IControlAttrs> {
    view({ attrs }: m.Vnode<IControlAttrs>): m.Vnode<any, any>;
}
