import * as tslib_1 from "tslib";
import m from 'mithril';
import { Classes } from '../../_shared';
import { BaseControl } from '../base-control';
var Checkbox = /** @class */ (function () {
    function Checkbox() {
    }
    Checkbox.prototype.oncreate = function (_a) {
        var attrs = _a.attrs, dom = _a.dom;
        this.input = dom.querySelector('input');
        if (attrs.defaultIndeterminate != null) {
            this.input.indeterminate = attrs.defaultIndeterminate;
        }
        this.updateIndeterminate(attrs);
    };
    Checkbox.prototype.onupdate = function (_a) {
        var attrs = _a.attrs, dom = _a.dom;
        this.input = dom.querySelector('input');
        this.updateIndeterminate(attrs);
    };
    Checkbox.prototype.view = function (_a) {
        var attrs = _a.attrs;
        return m(BaseControl, tslib_1.__assign({}, attrs, { type: 'checkbox', typeClass: Classes.CHECKBOX }));
    };
    Checkbox.prototype.updateIndeterminate = function (attrs) {
        if (attrs.indeterminate != null) {
            this.input.indeterminate = attrs.indeterminate;
        }
    };
    return Checkbox;
}());
export { Checkbox };
