import m from 'mithril';
import { IAttrs } from '../../_shared';
export interface IBreakpointMap {
    xs?: number;
    sm?: number;
    md?: number;
    lg?: number;
    xl?: number;
}
export interface IGridAttrs extends IAttrs {
    /** HTML element to render into */
    element?: string;
    /** Space between columns */
    gutter?: number | IBreakpointMap;
    /** Flexbox column alignment */
    align?: 'top' | 'middle' | 'bottom';
    /** Flexbox column justify */
    justify?: 'start' | 'end' | 'center' | 'space-around' | 'space-between';
    [htmlAttrs: string]: any;
}
export declare class Grid implements m.Component<IGridAttrs> {
    view({ attrs, children }: m.Vnode<IGridAttrs>): m.Vnode<any, any>;
    private getGutter;
    private renderCols;
}
