import * as tslib_1 from "tslib";
import m from 'mithril';
import classnames from 'classnames';
import { Classes, updateElementGroupPadding } from '../..';
import { Button } from '../button';
var InputFile = /** @class */ (function () {
    function InputFile() {
    }
    InputFile.prototype.oncreate = function (vnode) {
        this.updatePadding(vnode);
    };
    InputFile.prototype.onupdate = function (vnode) {
        this.updatePadding(vnode);
    };
    InputFile.prototype.view = function (_a) {
        var attrs = _a.attrs;
        var className = attrs.class, contentLeft = attrs.contentLeft, contentRight = attrs.contentRight, fluid = attrs.fluid, intent = attrs.intent, size = attrs.size, style = attrs.style, text = attrs.text, htmlAttrs = tslib_1.__rest(attrs, ["class", "contentLeft", "contentRight", "fluid", "intent", "size", "style", "text"]);
        var classes = classnames(Classes.INPUT_FILE, attrs.disabled && Classes.DISABLED, fluid && Classes.FLUID, intent && "cui-" + intent, size && "cui-" + size, className);
        this.browseButton = m(Button, {
            class: Classes.INPUT_FILE_BUTTON,
            label: 'Browse',
            tabindex: -1
        });
        var contentClasses = classnames(Classes.INPUT_FILE_CONTENT, text && Classes.INPUT_FILE_TEXT);
        var content = [
            contentLeft,
            m('input', tslib_1.__assign({ class: Classes.HIDDEN }, htmlAttrs, { type: 'file' })),
            m('', { class: contentClasses }, text || 'Choose a file...'),
            contentRight || this.browseButton
        ];
        return m('label', {
            class: classes,
            style: style,
            tabindex: 0
        }, content);
    };
    InputFile.prototype.updatePadding = function (_a) {
        var attrs = _a.attrs, dom = _a.dom;
        var containerEl = dom.querySelector("." + Classes.INPUT_FILE_CONTENT);
        updateElementGroupPadding(containerEl, attrs.contentLeft, attrs.contentRight || this.browseButton);
    };
    return InputFile;
}());
export { InputFile };
