import * as tslib_1 from "tslib";
import m from 'mithril';
import classnames from 'classnames';
import { Classes } from '../../_shared';
import { Button } from '../button';
import { PopoverMenu } from '../popover-menu';
import { Icons } from '../icon';
var MenuItem = /** @class */ (function () {
    function MenuItem() {
    }
    MenuItem.prototype.view = function (_a) {
        var attrs = _a.attrs;
        var className = attrs.class, submenu = attrs.submenu, closeOnSubmenuClick = attrs.closeOnSubmenuClick, popoverMenuAttrs = attrs.popoverMenuAttrs, buttonAttrs = tslib_1.__rest(attrs, ["class", "submenu", "closeOnSubmenuClick", "popoverMenuAttrs"]);
        var classes = classnames(Classes.MENU_ITEM, Classes.BASIC, className);
        var button = m(Button, tslib_1.__assign({ align: 'left', compact: true, iconRight: submenu ? Icons.CHEVRON_RIGHT : undefined }, buttonAttrs, { class: classes }));
        return submenu ? m(PopoverMenu, tslib_1.__assign({ hasArrow: false, interactionType: 'hover', openOnTriggerFocus: true, position: 'right-start' }, popoverMenuAttrs, { closeOnContentClick: closeOnSubmenuClick, addToStack: false, content: submenu, inline: true, restoreFocus: false, trigger: button })) : button;
    };
    return MenuItem;
}());
export { MenuItem };
