import * as tslib_1 from "tslib";
import m from 'mithril';
import { Breakpoints } from '../../_shared';
var enquirejs;
if (typeof window !== 'undefined') {
    var matchMediaPolyfill = function (mediaQuery) {
        return {
            media: mediaQuery,
            matches: false,
            // tslint:disable-next-line:no-empty
            addListener: function () {
            },
            // tslint:disable-next-line:no-empty
            removeListener: function () {
            }
        };
    };
    window.matchMedia = window.matchMedia || matchMediaPolyfill;
    // tslint:disable-next-line:no-var-requires
    enquirejs = require('enquire.js');
}
var breakpointKeys = Object.keys(Breakpoints);
var ResponsiveManager = /** @class */ (function () {
    function ResponsiveManager() {
        this.isInitialized = false;
    }
    /** Binds initial breakpoints */
    ResponsiveManager.prototype.initialize = function () {
        var _this = this;
        if (this.isInitialized) {
            return;
        }
        breakpointKeys.map(function (breakpoint) { return enquirejs.register(Breakpoints[breakpoint], {
            match: function () {
                var _a;
                _this.breakpoints = tslib_1.__assign({}, _this.breakpoints, (_a = {}, _a[breakpoint] = true, _a));
                m.redraw();
            },
            unmatch: function () {
                var _a;
                _this.breakpoints = tslib_1.__assign({}, _this.breakpoints, (_a = {}, _a[breakpoint] = false, _a));
                m.redraw();
            },
            // tslint:disable-next-line:no-empty
            destroy: function () { }
        }); });
        this.isInitialized = true;
    };
    /** Checks if current breakpoint string is active */
    ResponsiveManager.prototype.is = function (key) {
        return this.breakpoints[key] === true;
    };
    /** Unbinds all breakpoints */
    ResponsiveManager.prototype.destroy = function () {
        breakpointKeys.map(function (breakpoint) { return enquirejs.unregister(Breakpoints[breakpoint]); });
    };
    return ResponsiveManager;
}());
export default new ResponsiveManager();
