'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mixinStringifySafe;

var _jsonStringifySafe = require('json-stringify-safe');

var _jsonStringifySafe2 = _interopRequireDefault(_jsonStringifySafe);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function mixinStringifySafe(data) {
  return Object.defineProperty(data, 'stringifySafe', {
    enumerable: false,
    configurable: false,
    writable: false,
    value: function value() {
      var serializer = arguments.length <= 0 || arguments[0] === undefined ? null : arguments[0];
      var indent = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];

      return (0, _jsonStringifySafe2.default)(this, serializer, indent, function (key, value) {
        return {
          sys: {
            type: 'Link',
            linkType: 'Entry',
            id: value.sys.id,
            circular: true
          }
        };
      });
    }
  });
}